#!/bin/bash
export datasets="Cora CiteSeer PubMed cs physics wikics OGBN-Arxiv"
# export datasets2="OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_test="0.5 0.999 1.0"
export vers="1"
export lambda_list="1e-5 1e-4 1e-3 1e-2 1e-1 1e+0 1e+1"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=2

# uniform
for ver in $vers
do
for dataset in $datasets
do
for missing_rate in $missing_rates_test
do
for lamb in $lambda_list
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --lamb ${lamb} --lp_temp 1.0 --embedder GOODIE --filling_method fp --n_runs 3 --gpu ${gpu} --ver ${ver}
done
done
done
done